/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.networking.v1;

import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.impl.networking.client.ClientNetworkingImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerCommonPacketListener;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.sinytra.fabric.networking_api.client.NeoClientPlayNetworking;

public final class ClientPlayNetworking {
    public static <T extends CustomPacketPayload> boolean registerGlobalReceiver(CustomPacketPayload.Type<T> type, PlayPayloadHandler<T> handler) {
        return NeoClientPlayNetworking.registerGlobalReceiver(type, handler);
    }

    @Nullable
    public static PlayPayloadHandler<?> unregisterGlobalReceiver(ResourceLocation id) {
        return NeoClientPlayNetworking.unregisterGlobalReceiver(id);
    }

    public static Set<ResourceLocation> getGlobalReceivers() {
        return NeoClientPlayNetworking.getGlobalReceivers();
    }

    public static <T extends CustomPacketPayload> boolean registerReceiver(CustomPacketPayload.Type<T> type, PlayPayloadHandler<T> handler) {
        return NeoClientPlayNetworking.registerReceiver(type, handler);
    }

    @Nullable
    public static PlayPayloadHandler<?> unregisterReceiver(ResourceLocation id) {
        return NeoClientPlayNetworking.unregisterReceiver(id);
    }

    public static Set<ResourceLocation> getReceived() throws IllegalStateException {
        return NeoClientPlayNetworking.getReceived();
    }

    public static Set<ResourceLocation> getSendable() throws IllegalStateException {
        return NeoClientPlayNetworking.getSendable();
    }

    public static boolean canSend(ResourceLocation channelName) throws IllegalArgumentException {
        if (Minecraft.getInstance().getConnection() != null && Minecraft.getInstance().getConnection().protocol() == ConnectionProtocol.PLAY) {
            return NeoClientPlayNetworking.canSend(channelName);
        }
        return false;
    }

    public static boolean canSend(CustomPacketPayload.Type<?> type) {
        return ClientPlayNetworking.canSend(type.id());
    }

    public static <T extends CustomPacketPayload> Packet<ServerCommonPacketListener> createC2SPacket(T packet) {
        return ClientNetworkingImpl.createC2SPacket(packet);
    }

    public static PacketSender getSender() throws IllegalStateException {
        return NeoClientPlayNetworking.getSender();
    }

    public static void send(CustomPacketPayload payload) {
        Objects.requireNonNull(payload, "Payload cannot be null");
        Objects.requireNonNull(payload.type(), "CustomPayload#getId() cannot return null for payload class: " + String.valueOf(payload.getClass()));
        if (Minecraft.getInstance().getConnection() != null) {
            Minecraft.getInstance().getConnection().send(ClientPlayNetworking.createC2SPacket(payload));
            return;
        }
        throw new IllegalStateException("Cannot send packets when not in game!");
    }

    private ClientPlayNetworking() {
    }

    @FunctionalInterface
    public static interface PlayPayloadHandler<T extends CustomPacketPayload> {
        public void receive(T var1, Context var2);
    }

    @ApiStatus.NonExtendable
    public static interface Context {
        public Minecraft client();

        public LocalPlayer player();

        public PacketSender responseSender();
    }
}

